/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.camera.capture;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.exposure.data.ColorPalette;
import io.github.mortuusars.exposure.data.ColorPalettes;
import io.github.mortuusars.exposure.util.ExtraData;
import io.github.mortuusars.exposure.world.camera.CameraId;
import io.github.mortuusars.exposure.world.camera.ColorChannel;
import io.github.mortuusars.exposure.world.camera.ExposureType;
import io.github.mortuusars.exposure.world.camera.capture.ProjectionInfo;
import io.github.mortuusars.exposure.world.camera.component.ShutterSpeed;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record CaptureProperties(String exposureId, ExposureType filmType, Optional<class_6880<ColorPalette>> colorPalette, Optional<Integer> frameSize, float cropFactor, Optional<ShutterSpeed> shutterSpeed, Optional<Float> fovOverride, boolean flash, Optional<ProjectionInfo> projection, Optional<ColorChannel> singleChannel, Optional<Integer> cameraHolderEntityId, Optional<CameraId> cameraId, ExtraData extraData) {
    public static final ExtraData.Entry<Integer> LIGHT_LEVEL = new ExtraData.Entry<Integer>("light_level", class_2487::method_10550, class_2487::method_10569);
    public static final Codec<CaptureProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(CaptureProperties::exposureId), (App)ExposureType.CODEC.optionalFieldOf("film_type", (Object)ExposureType.COLOR).forGetter(CaptureProperties::filmType), (App)ColorPalette.HOLDER_CODEC.optionalFieldOf("color_palette").forGetter(CaptureProperties::colorPalette), (App)Codec.INT.optionalFieldOf("frame_size").forGetter(CaptureProperties::frameSize), (App)Codec.FLOAT.optionalFieldOf("crop_factor", (Object)Float.valueOf(1.0f)).forGetter(CaptureProperties::cropFactor), (App)ShutterSpeed.CODEC.optionalFieldOf("shutter_speed").forGetter(CaptureProperties::shutterSpeed), (App)Codec.FLOAT.optionalFieldOf("fov_override").forGetter(CaptureProperties::fovOverride), (App)Codec.BOOL.optionalFieldOf("flash", (Object)false).forGetter(CaptureProperties::flash), (App)ProjectionInfo.CODEC.optionalFieldOf("projection").forGetter(CaptureProperties::projection), (App)ColorChannel.CODEC.optionalFieldOf("single_channel").forGetter(CaptureProperties::singleChannel), (App)Codec.INT.optionalFieldOf("camera_holder_id").forGetter(CaptureProperties::cameraHolderEntityId), (App)CameraId.CODEC.optionalFieldOf("camera_id").forGetter(CaptureProperties::cameraId), (App)ExtraData.CODEC.optionalFieldOf("extra_data", (Object)new ExtraData()).forGetter(CaptureProperties::extraData)).apply((Applicative)instance, CaptureProperties::new));
    public static final class_9139<class_9129, CaptureProperties> STREAM_CODEC = new class_9139<class_9129, CaptureProperties>(){

        @NotNull
        public CaptureProperties decode(class_9129 buffer) {
            return new CaptureProperties((String)class_9135.field_48554.decode((Object)buffer), (ExposureType)((Object)ExposureType.STREAM_CODEC.decode((Object)buffer)), (Optional)class_9135.method_56382(ColorPalette.STREAM_CODEC).decode((Object)buffer), (Optional)class_9135.method_56382((class_9139)class_9135.field_48550).decode((Object)buffer), ((Float)class_9135.field_48552.decode((Object)buffer)).floatValue(), (Optional)class_9135.method_56382(ShutterSpeed.STREAM_CODEC).decode((Object)buffer), (Optional)class_9135.method_56382((class_9139)class_9135.field_48552).decode((Object)buffer), (Boolean)class_9135.field_48547.decode((Object)buffer), (Optional)class_9135.method_56382(ProjectionInfo.STREAM_CODEC).decode((Object)buffer), (Optional)class_9135.method_56382(ColorChannel.STREAM_CODEC).decode((Object)buffer), (Optional)class_9135.method_56382((class_9139)class_9135.field_48550).decode((Object)buffer), (Optional)class_9135.method_56382(CameraId.STREAM_CODEC).decode((Object)buffer), (ExtraData)((Object)ExtraData.STREAM_CODEC.decode((Object)buffer)));
        }

        public void encode(class_9129 buffer, CaptureProperties data) {
            class_9135.field_48554.encode((Object)buffer, (Object)data.exposureId());
            ExposureType.STREAM_CODEC.encode((Object)buffer, (Object)data.filmType());
            class_9135.method_56382(ColorPalette.STREAM_CODEC).encode((Object)buffer, data.colorPalette());
            class_9135.method_56382((class_9139)class_9135.field_48550).encode((Object)buffer, data.frameSize());
            class_9135.field_48552.encode((Object)buffer, (Object)Float.valueOf(data.cropFactor()));
            class_9135.method_56382(ShutterSpeed.STREAM_CODEC).encode((Object)buffer, data.shutterSpeed());
            class_9135.method_56382((class_9139)class_9135.field_48552).encode((Object)buffer, data.fovOverride());
            class_9135.field_48547.encode((Object)buffer, (Object)data.flash());
            class_9135.method_56382(ProjectionInfo.STREAM_CODEC).encode((Object)buffer, data.projection());
            class_9135.method_56382(ColorChannel.STREAM_CODEC).encode((Object)buffer, data.singleChannel());
            class_9135.method_56382((class_9139)class_9135.field_48550).encode((Object)buffer, data.cameraHolderEntityId());
            class_9135.method_56382(CameraId.STREAM_CODEC).encode((Object)buffer, data.cameraId());
            ExtraData.STREAM_CODEC.encode((Object)buffer, (Object)data.extraData());
        }
    };

    public ShutterSpeed getShutterSpeed() {
        return this.shutterSpeed.orElse(ShutterSpeed.DEFAULT);
    }

    public class_6880<ColorPalette> getColorPalette(class_5455 access) {
        return this.colorPalette.orElse(ColorPalettes.getDefault(access));
    }

    public static final class Builder {
        private final String exposureId;
        private ExposureType filmType = ExposureType.COLOR;
        @Nullable
        private class_6880<ColorPalette> colorPalette = null;
        @Nullable
        private Integer frameSize = null;
        private float cropFactor = 1.0f;
        @Nullable
        private ShutterSpeed shutterSpeed = null;
        @Nullable
        private Float fovOverride = null;
        private boolean flash = false;
        @Nullable
        private ProjectionInfo projectionInfo;
        @Nullable
        private ColorChannel chromaticChannel;
        @Nullable
        private Integer cameraHolderEntityID = null;
        @Nullable
        private CameraId cameraId = null;
        private final ExtraData extraData = new ExtraData();

        public Builder(String exposureId) {
            this.exposureId = exposureId;
        }

        public Builder setFilmType(@Nullable ExposureType filmType) {
            this.filmType = filmType;
            return this;
        }

        public Builder setColorPalette(@Nullable class_6880<ColorPalette> colorPalette) {
            this.colorPalette = colorPalette;
            return this;
        }

        public Builder setFrameSize(@Nullable Integer frameSize) {
            this.frameSize = frameSize;
            return this;
        }

        public Builder setCropFactor(float cropFactor) {
            this.cropFactor = cropFactor;
            return this;
        }

        public Builder setShutterSpeed(@Nullable ShutterSpeed shutterSpeed) {
            this.shutterSpeed = shutterSpeed;
            return this;
        }

        public Builder setFovOverride(@Nullable Float fovOverride) {
            this.fovOverride = fovOverride;
            return this;
        }

        public Builder setFlash(boolean flash) {
            this.flash = flash;
            return this;
        }

        public Builder setCameraHolder(@Nullable CameraHolder holder) {
            this.cameraHolderEntityID = holder == null ? null : Integer.valueOf(holder.asHolderEntity().method_5628());
            return this;
        }

        public Builder setCameraID(@Nullable CameraId cameraId) {
            this.cameraId = cameraId;
            return this;
        }

        public Builder setCameraID(Optional<CameraId> cameraId) {
            this.cameraId = cameraId.orElse(null);
            return this;
        }

        public Builder setProjectionInfo(@Nullable ProjectionInfo projectionInfo) {
            this.projectionInfo = projectionInfo;
            return this;
        }

        public Builder setProjectingInfo(Optional<ProjectionInfo> projectingInfo) {
            this.projectionInfo = projectingInfo.orElse(null);
            return this;
        }

        public Builder setChromaticChannel(@Nullable ColorChannel chromaticChannel) {
            this.chromaticChannel = chromaticChannel;
            return this;
        }

        public Builder setChromaticChannel(Optional<ColorChannel> chromaticChannel) {
            this.chromaticChannel = chromaticChannel.orElse(null);
            return this;
        }

        public Builder extraData(Consumer<ExtraData> extraDataUpdater) {
            extraDataUpdater.accept(this.extraData);
            return this;
        }

        public CaptureProperties build() {
            return new CaptureProperties(this.exposureId, this.filmType, Optional.ofNullable(this.colorPalette), Optional.ofNullable(this.frameSize), this.cropFactor, Optional.ofNullable(this.shutterSpeed), Optional.ofNullable(this.fovOverride), this.flash, Optional.ofNullable(this.projectionInfo), Optional.ofNullable(this.chromaticChannel), Optional.ofNullable(this.cameraHolderEntityID), Optional.ofNullable(this.cameraId), this.extraData);
        }
    }
}

